/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.RelaxedX509ExtendedTrustManager;
import org.opennms.netmgt.provision.DetectFuture;
import org.opennms.netmgt.provision.support.AsyncBasicDetector;
import org.opennms.netmgt.provision.support.AsyncClientConversation;
import org.opennms.netmgt.provision.support.DetectFutureFailedImpl;
import org.opennms.netmgt.provision.support.DetectFutureNettyImpl;
import org.opennms.netmgt.provision.support.DetectorHandlerNettyImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncBasicDetectorNettyImpl<Request, Response>
extends AsyncBasicDetector<Request, Response> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncBasicDetectorNettyImpl.class);

    public AsyncBasicDetectorNettyImpl(String serviceName, int port) {
        super(serviceName, port);
    }

    public AsyncBasicDetectorNettyImpl(String serviceName, int port, int timeout, int retries) {
        super(serviceName, port, timeout, retries);
    }

    @Override
    public void dispose() {
        LOG.debug("calling dispose on detector {}", (Object)this.getServiceName());
    }

    @Override
    public final DetectFuture isServiceDetected(InetAddress address) {
        DetectFuture detectFuture = new DetectFutureFailedImpl(this, new IllegalStateException());
        try {
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.channel(NioSocketChannel.class)).group((EventLoopGroup)eventLoopGroup)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioSocketChannel>(){

                protected void initChannel(NioSocketChannel nioSocketChannel) throws Exception {
                    ChannelPipeline retval = nioSocketChannel.pipeline();
                    AsyncBasicDetectorNettyImpl.this.appendToPipeline(retval);
                    retval.addLast("detectorHandler", AsyncBasicDetectorNettyImpl.this.getDetectorHandler(AsyncBasicDetectorNettyImpl.this.getConversation()));
                    if (AsyncBasicDetectorNettyImpl.this.isUseSSLFilter()) {
                        retval.addLast("sslHandler", (ChannelHandler)new SslHandler(AsyncBasicDetectorNettyImpl.createClientSSLContext().createSSLEngine()));
                    }
                }
            });
            InetSocketAddress remoteAddress = new InetSocketAddress(address, this.getPort());
            ChannelFuture future = bootstrap.connect((SocketAddress)remoteAddress);
            future.addListener((GenericFutureListener)new RetryChannelFutureListener(remoteAddress, this.getRetries()));
            detectFuture = new DetectFutureNettyImpl(this, (ChannelPromise)future);
        }
        catch (Throwable e) {
            detectFuture = new DetectFutureFailedImpl(this, e);
        }
        return detectFuture;
    }

    protected void appendToPipeline(ChannelPipeline retval) {
    }

    protected DetectorHandlerNettyImpl<Request, Response> getDetectorHandler(AsyncClientConversation<Request, Response> conversation) {
        DetectorHandlerNettyImpl<Request, Response> handler = new DetectorHandlerNettyImpl<Request, Response>();
        handler.setConversation(conversation);
        return handler;
    }

    private static SSLContext createClientSSLContext() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] tm = new TrustManager[]{new RelaxedX509ExtendedTrustManager()};
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, tm, new SecureRandom());
        return sslContext;
    }

    private class RetryChannelFutureListener
    implements GenericFutureListener<ChannelPromise> {
        private final SocketAddress m_remoteAddress;
        private int m_retries;

        public RetryChannelFutureListener(SocketAddress remoteAddress, int retries) {
            this.m_remoteAddress = remoteAddress;
            this.m_retries = retries;
        }

        public void operationComplete(ChannelPromise future) {
            Throwable cause = future.cause();
            if (cause != null) {
                if (cause instanceof IOException) {
                    if (this.m_retries == 0) {
                        LOG.info("Service {} detected false", (Object)AsyncBasicDetectorNettyImpl.this.getServiceName());
                        future.setFailure((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                    } else {
                        LOG.info("Connection exception occurred {} for service {}, retrying attempt {}", new Object[]{cause, AsyncBasicDetectorNettyImpl.this.getServiceName(), this.m_retries});
                        InetSocketAddress localAddress = new InetSocketAddress(InetAddressUtils.getLocalHostAddress(), 0);
                        future.removeListener((GenericFutureListener)this);
                        LOG.error("RETRIES {}", (Object)this.m_retries);
                        future.addListener((GenericFutureListener)new RetryChannelFutureListener(this.m_remoteAddress, this.m_retries - 1));
                        future.channel().bind((SocketAddress)localAddress);
                        future.channel().connect(this.m_remoteAddress);
                    }
                } else {
                    LOG.info("Threw a Throwable and detection is false for service {}", (Object)AsyncBasicDetectorNettyImpl.this.getServiceName(), (Object)cause);
                    future.setFailure((Throwable)new DetectFutureNettyImpl.ServiceDetectionFailedException());
                }
            }
        }
    }
}

