/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.felix.webconsole.internal.AbstractConfigurationPrinter;
import org.apache.felix.webconsole.internal.misc.ConfigurationRender;
import org.osgi.framework.Bundle;
import org.osgi.framework.dto.FrameworkDTO;

public class FrameworkPropertiesPrinter
extends AbstractConfigurationPrinter {
    private static final String TITLE = "Framework Properties";

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public void printConfiguration(PrintWriter printWriter) {
        this.getFrameworkProperties().entrySet().stream().forEach(e -> ConfigurationRender.infoLine(printWriter, null, (String)e.getKey(), e.getValue()));
    }

    private Map<String, String> getFrameworkProperties() {
        Bundle systemBundle = this.getBundleContext().getBundle(0L);
        FrameworkDTO framework = (FrameworkDTO)systemBundle.adapt(FrameworkDTO.class);
        return framework.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> FrameworkPropertiesPrinter.getStringValue(e.getValue()), (key1, key2) -> key1, TreeMap::new));
    }

    private static final String getStringValue(Object object) {
        if (object.getClass().isArray()) {
            StringBuilder values = new StringBuilder("[");
            int length = Array.getLength(object);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    values.append(" ,");
                }
                values.append(FrameworkPropertiesPrinter.getStringValue(Array.get(object, i)));
            }
            values.append("]");
            return values.toString();
        }
        if (object instanceof String) {
            return object.toString();
        }
        return object.toString() + " (" + object.getClass() + ")";
    }
}

