/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.info;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opennms.netmgt.graph.api.info.GraphInfo;

public class DefaultGraphInfo
implements GraphInfo {
    private String namespace;
    private String description;
    private String label;

    public DefaultGraphInfo(String namespace) {
        this.namespace = Objects.requireNonNull(namespace);
    }

    public DefaultGraphInfo(GraphInfo copy) {
        this(Objects.requireNonNull(copy).getNamespace());
        this.setLabel(copy.getLabel());
        this.setDescription(copy.getDescription());
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public DefaultGraphInfo withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public DefaultGraphInfo withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultGraphInfo graphInfo = (DefaultGraphInfo)o;
        return Objects.equals(this.namespace, graphInfo.namespace) && Objects.equals(this.description, graphInfo.description) && Objects.equals(this.label, graphInfo.label);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.description, this.label);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("namespace", (Object)this.namespace).add("label", (Object)this.label).add("description", (Object)this.description).toString();
    }
}

