/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.generic;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.Vertex;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.aware.NodeRefAware;
import org.opennms.netmgt.graph.api.generic.GenericElement;
import org.slf4j.LoggerFactory;

public final class GenericVertex
extends GenericElement
implements Vertex,
NodeRefAware {
    private GenericVertex(Map<String, Object> properties) {
        super(properties);
        Objects.requireNonNull(this.getId(), "id cannot be null");
    }

    @Override
    public VertexRef getVertexRef() {
        return new VertexRef(this.getNamespace(), this.getId());
    }

    @Override
    public NodeRef getNodeRef() {
        List<NodeRef> nodeRefs = NodeRef.from(this);
        if (nodeRefs.isEmpty()) {
            return null;
        }
        if (nodeRefs.size() > 1) {
            LoggerFactory.getLogger(this.getClass()).warn("Vertex has multiple node references: {}. Using first one: {}", nodeRefs, (Object)nodeRefs.get(0));
        }
        return nodeRefs.get(0);
    }

    @Override
    public GenericVertex asGenericVertex() {
        return this;
    }

    public static GenericVertexBuilder builder() {
        return new GenericVertexBuilder();
    }

    public static final class GenericVertexBuilder
    extends GenericElement.GenericElementBuilder<GenericVertexBuilder> {
        private GenericVertexBuilder() {
        }

        @Override
        public GenericVertexBuilder id(String id) {
            this.property("id", id);
            return this;
        }

        public GenericVertexBuilder vertex(GenericVertex vertex) {
            Objects.requireNonNull(vertex);
            this.properties(vertex.getProperties());
            return this;
        }

        public GenericVertexBuilder nodeRef(String foreignSource, String foreignId) {
            this.property("foreignSource", foreignSource);
            this.property("foreignID", foreignId);
            return this;
        }

        public GenericVertex build() {
            return new GenericVertex(this.properties);
        }
    }
}

