/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.enrichment;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericElement;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;

public final class EnrichmentGraphBuilder {
    private final GenericGraph view;
    private final Map<VertexRef, Map<String, Object>> vertexRefToPropertiesMap = Maps.newHashMap();
    private final Map<String, Map<String, Object>> edgeIdToPropertiesMap = Maps.newHashMap();
    private final Map<String, Object> graphProperties = Maps.newHashMap();

    public EnrichmentGraphBuilder(GenericGraph input) {
        this.view = Objects.requireNonNull(input);
    }

    public GenericGraph getView() {
        return this.view;
    }

    public List<GenericVertex> getVertices() {
        return this.getView().getVertices();
    }

    public List<GenericEdge> getEdges() {
        return this.getView().getEdges();
    }

    public List<GenericVertex> resolveVertices(NodeRef nodeRef) {
        return this.getView().resolveVertices(nodeRef);
    }

    public <T> EnrichmentGraphBuilder property(String name, T value) {
        this.property(this.view, name, value, () -> this.graphProperties);
        return this;
    }

    public <T> EnrichmentGraphBuilder property(GenericVertex vertex, String name, T value) {
        Objects.requireNonNull(vertex);
        this.property(vertex, name, value, () -> this.getVertexProperties(vertex.getVertexRef()));
        return this;
    }

    public <T> EnrichmentGraphBuilder property(GenericEdge edge, String name, T value) {
        this.property(edge, name, value, () -> this.getEdgeProperties(edge));
        return this;
    }

    private <T> EnrichmentGraphBuilder property(GenericElement element, String name, T value, Supplier<Map<String, Object>> enrichedPropertiesMapSupplier) {
        Objects.requireNonNull(element);
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        if (element.getProperty(name) != null) {
            throw new IllegalArgumentException(String.format("Cannot change existing property on '%s' graph element with id '%s'", element.getClass().getSimpleName(), element.getId()));
        }
        Map<String, Object> enrichedProperties = enrichedPropertiesMapSupplier.get();
        if (enrichedProperties != null) {
            enrichedProperties.put(name, value);
        }
        return this;
    }

    private Map<String, Object> getVertexProperties(VertexRef vertexRef) {
        Objects.requireNonNull(vertexRef);
        if (this.view.resolveVertex(vertexRef) == null) {
            throw new IllegalArgumentException(String.format("Vertex with id '%s' does not exist", vertexRef.getId()));
        }
        if (!this.vertexRefToPropertiesMap.containsKey(vertexRef)) {
            this.vertexRefToPropertiesMap.put(vertexRef, new HashMap());
        }
        return this.vertexRefToPropertiesMap.get(vertexRef);
    }

    private Map<String, Object> getEdgeProperties(GenericEdge edge) {
        Objects.requireNonNull(edge);
        String edgeId = edge.getId();
        if (this.view.getEdge(edgeId) == null) {
            throw new IllegalArgumentException(String.format("Edge with id '%s' does not exist", edgeId));
        }
        if (!this.edgeIdToPropertiesMap.containsKey(edgeId)) {
            this.edgeIdToPropertiesMap.put(edgeId, new HashMap());
        }
        return this.edgeIdToPropertiesMap.get(edgeId);
    }

    public GenericGraph build() {
        GenericGraph.GenericGraphBuilder genericGraphBuilder = ((GenericGraph.GenericGraphBuilder)((GenericGraph.GenericGraphBuilder)GenericGraph.builder().properties((Map)this.view.getProperties())).properties((Map)this.graphProperties)).focus(this.view.getDefaultFocus());
        this.view.getVertices().forEach(vertex -> {
            GenericVertex enrichedVertex = ((GenericVertex.GenericVertexBuilder)GenericVertex.builder().vertex((GenericVertex)vertex).properties(this.getVertexProperties(vertex.getVertexRef()))).build();
            genericGraphBuilder.addVertex(enrichedVertex);
        });
        this.view.getEdges().forEach(edge -> {
            GenericEdge enrichedEdge = ((GenericEdge.GenericEdgeBuilder)GenericEdge.builder().edge((GenericEdge)edge).properties(this.getEdgeProperties((GenericEdge)edge))).build();
            genericGraphBuilder.addEdge(enrichedEdge);
        });
        return genericGraphBuilder.build();
    }
}

