/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.scriptd.helper;

import java.io.File;
import java.io.IOException;
import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogFilter;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogUtils;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.xml.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class SyslogEventForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogEventForwarder.class);
    private SyslogDestination destination;
    private boolean initialized = false;

    public void initialize(String destinationName) {
        File configFile = this.getConfigFile(destinationName);
        if (configFile != null && configFile.exists()) {
            LOG.info("Initializing Syslog instance for destination: '{}'", (Object)destinationName);
            this.destination = (SyslogDestination)JaxbUtils.unmarshal(SyslogDestination.class, (File)configFile);
            this.destination.setName(destinationName);
            SyslogUtils.createNorthboundInstance(this.destination);
            this.initialized = true;
        } else {
            LOG.error("Can't load configuration from {}", (Object)configFile);
        }
    }

    public void shutdown() {
        if (this.initialized) {
            try {
                LOG.info("Shutting down Syslog instance for destination: '{}'", (Object)this.destination.getName());
                this.initialized = false;
                SyslogIF instance = Syslog.getInstance((String)this.destination.getName());
                Syslog.destroyInstance((SyslogIF)instance);
            }
            catch (SyslogRuntimeException e) {
                LOG.error("Could not find Syslog instance for destination: '{}': {}", (Object)this.destination.getName(), (Object)e);
                return;
            }
        } else {
            LOG.error("Can't shutdown a SYslog instance for an uninitialized forwarder.");
        }
    }

    public void reload() {
        if (this.initialized) {
            LOG.info("Reloading Syslog instance for destination: '{}'", (Object)this.destination.getName());
            this.shutdown();
            this.initialize(this.destination.getName());
        } else {
            LOG.error("Can't reload configuration for an uninitialized forwarder.");
        }
    }

    public void forward(Event event, OnmsNode node) {
        block8: {
            if (this.initialized) {
                SyslogIF instance;
                LOG.info("Forwarding event {} to destination:{}", (Object)event.getUei(), (Object)this.destination.getName());
                try {
                    instance = Syslog.getInstance((String)this.destination.getName());
                }
                catch (SyslogRuntimeException e) {
                    LOG.error("Could not find Syslog instance for destination: '{}': {}", (Object)this.destination.getName(), (Object)e);
                    return;
                }
                try {
                    LOG.debug("Making substitutions for tokens in message format for event: {}.", (Object)event.getDbid());
                    String msgFormat = null;
                    for (SyslogFilter filter : this.destination.getFilters()) {
                        if (!this.passFilter(filter, event)) continue;
                        msgFormat = filter.getMessageFormat();
                    }
                    if (msgFormat != null) {
                        String syslogMessage = this.getTranslatedMessage(event, node, msgFormat);
                        LOG.debug("Determining LOG_LEVEL for event: {}", (Object)event.getDbid());
                        int level = SyslogUtils.determineLogLevel(OnmsSeverity.get((String)event.getSeverity()));
                        LOG.debug("Forwarding event: {} via syslog to destination: {}", (Object)event.getDbid(), (Object)this.destination.getName());
                        instance.log(level, syslogMessage);
                        break block8;
                    }
                    LOG.warn("Can't find message format for the incoming. Check your destination's configuration.");
                }
                catch (Exception ex) {
                    LOG.error("Caught exception sending to destination: '{}': {}", (Object)this.destination.getName(), (Object)ex);
                }
            } else {
                LOG.error("Can't forward event {} because the facility has not been initialized.", (Object)event.getUei());
            }
        }
    }

    private File getConfigFile(String destinationName) {
        try {
            return ConfigFileConstants.getConfigFileByName((String)("syslog-eventforwarder-" + destinationName + ".xml"));
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean passFilter(SyslogFilter filter, Event event) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)event);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(filter.getRule());
        boolean passed = false;
        try {
            passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOG.warn("passFilter: can't evaluate expression {} for alarm {} because: {}", new Object[]{filter.getRule(), event.getUei(), e.getMessage()});
        }
        LOG.debug("passFilter: checking {} ? {}", (Object)filter.getRule(), (Object)passed);
        return passed;
    }

    private String getTranslatedMessage(Event event, OnmsNode node, String msgFormat) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)event);
        if (node != null) {
            context.setVariable("node", (Object)node);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(msgFormat, (ParserContext)new TemplateParserContext("${", "}"));
        try {
            String msg = (String)exp.getValue((EvaluationContext)context, String.class);
            LOG.debug("getTranslatedMessage: {} ==> {}", (Object)msgFormat, (Object)msg);
            return msg;
        }
        catch (Exception e) {
            LOG.warn("getTranslatedMessage: can't evaluate expression {} for alarm {} because: {}", new Object[]{msgFormat, event.getUei(), e.getMessage()});
            return null;
        }
    }
}

