/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.pattern;

import java.util.List;
import java.util.stream.Collectors;
import org.opennms.container.web.bridge.proxy.pattern.PatternMatcher;
import org.opennms.container.web.bridge.proxy.pattern.matchers.ExactPathMatcher;
import org.opennms.container.web.bridge.proxy.pattern.matchers.PathMatcher;

public final class PatternMatcherFactory {
    private PatternMatcherFactory() {
    }

    public static PatternMatcher createPatternMatcher(String pattern) {
        if (pattern.endsWith("/*")) {
            return new PathMatcher(pattern);
        }
        return new ExactPathMatcher(pattern);
    }

    public static List<PatternMatcher> determinePatternMatcher(List<String> patterns) {
        return patterns.stream().map(pattern -> PatternMatcherFactory.createPatternMatcher(pattern)).collect(Collectors.toList());
    }
}

