/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.health.api;

import java.time.Duration;
import java.time.Instant;
import java.util.List;
import org.opennms.core.health.api.CachingHealthCheck;
import org.opennms.core.health.api.Context;
import org.opennms.core.health.api.Response;
import org.opennms.core.health.api.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPassiveHealthCheck
implements CachingHealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPassiveHealthCheck.class);
    private final String description;
    private final List<String> tags;
    private Response cachedResponse = null;
    private Instant cachedResponseTimestamp = null;
    private boolean cachedExpires = true;

    public DefaultPassiveHealthCheck(String description, List<String> tags, Status initialStatus) {
        this.description = description;
        this.tags = tags;
        this.setResponse(new Response(initialStatus));
    }

    @Override
    public synchronized void setResponse(Response response) {
        this.setResponse(response, true);
    }

    public synchronized void setResponse(Response response, boolean expires) {
        LOG.debug("Cache response - healthCheck: {}; status: {}; msg: {}", new Object[]{this.description, response.getStatus(), response.getMessage()});
        this.cachedResponse = response;
        this.cachedResponseTimestamp = Instant.now();
        this.cachedExpires = expires;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getTags() {
        return this.tags;
    }

    @Override
    public synchronized Response perform(Context context) throws Exception {
        if (!this.cachedExpires || Duration.between(this.cachedResponseTimestamp, Instant.now()).compareTo(context.getMaxAge()) < 0) {
            return this.cachedResponse;
        }
        return new Response(Status.Failure, String.format("did not receive a recent response - maxAge: %s", context.getMaxAge()));
    }
}

