/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.dao.impl.util;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaDocumentation;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaRestriction;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaVisitor;
import org.apache.ws.commons.schema.walker.XmlSchemaWalker;
import org.opennms.features.config.dao.api.ConfigItem;
import org.opennms.features.config.dao.impl.util.NoopXmlSchemaVisitor;
import org.opennms.features.config.exception.ConfigConversionException;
import org.opennms.features.config.exception.SchemaConversionException;
import org.w3c.dom.Node;

public class XsdModelConverter
extends NoopXmlSchemaVisitor {
    public static final String XML_ELEMENT_VALUE_BODY_TAG = "body-name";
    private final Map<QName, ConfigItem> configItemsByQName = new LinkedHashMap<QName, ConfigItem>();
    private final List<ConfigItem> configItemStack = new LinkedList<ConfigItem>();
    private ConfigItem currentConfigItem;
    private XmlSchemaCollection collection;
    private Map<String, String> elementNameToValueNameMap = null;

    public XsdModelConverter(String xsdStr) {
        this.collection = this.convertToSchemaCollection(xsdStr);
    }

    public XmlSchemaCollection getCollection() {
        return this.collection;
    }

    private XmlSchemaCollection convertToSchemaCollection(String xsdStr) {
        XmlSchemaCollection schemaCollection = new XmlSchemaCollection();
        try (StringReader reader = new StringReader(xsdStr);){
            schemaCollection.read((Reader)reader);
        }
        return schemaCollection;
    }

    public ConfigItem convert(String topLevelElement) {
        XmlSchemaWalker walker = new XmlSchemaWalker(this.collection, (XmlSchemaVisitor)this);
        XmlSchemaElement rootEl = this.getElementOf(this.collection, topLevelElement);
        if (rootEl == null) {
            throw new SchemaConversionException("No element found with name: " + topLevelElement);
        }
        this.elementNameToValueNameMap = new HashMap<String, String>();
        walker.walk(rootEl);
        return this.configItemsByQName.get(rootEl.getQName());
    }

    public Map<String, String> getElementNameToValueNameMap() {
        if (this.elementNameToValueNameMap == null) {
            throw new ConfigConversionException("Should call after convert.");
        }
        return this.elementNameToValueNameMap;
    }

    private void handleExternalAttributes(XmlSchemaElement xmlSchemaElement) {
        if (xmlSchemaElement.getMetaInfoMap() == null) {
            return;
        }
        Object attributes = xmlSchemaElement.getMetaInfoMap().get("EXTERNAL_ATTRIBUTES");
        if (attributes instanceof Map) {
            ((Map)attributes).forEach((key, value) -> {
                Node attr;
                if (value instanceof Node && XML_ELEMENT_VALUE_BODY_TAG.equals((attr = (Node)value).getLocalName())) {
                    String tmpName = xmlSchemaElement.getQName().getLocalPart();
                    this.elementNameToValueNameMap.computeIfAbsent(tmpName, elementName -> attr.getNodeValue());
                    return;
                }
            });
        }
    }

    @Override
    public void onEnterElement(XmlSchemaElement xmlSchemaElement, XmlSchemaTypeInfo xmlSchemaTypeInfo, boolean b) {
        this.handleExternalAttributes(xmlSchemaElement);
        this.currentConfigItem = this.configItemsByQName.get(xmlSchemaElement.getQName());
        if (this.currentConfigItem == null) {
            ConfigItem.Type baseType = this.getConfigType(xmlSchemaTypeInfo.getBaseType().name());
            this.currentConfigItem = new ConfigItem();
            this.currentConfigItem.setName(xmlSchemaElement.getQName().getLocalPart());
            this.currentConfigItem.setDocumentation(this.getDocumentation(xmlSchemaElement.getAnnotation()));
            this.currentConfigItem.setSchemaRef(xmlSchemaElement.getQName().toString());
            this.currentConfigItem.setType(baseType);
            this.setRestrictions(this.currentConfigItem, xmlSchemaTypeInfo.getFacets());
            this.configItemsByQName.put(xmlSchemaElement.getQName(), this.currentConfigItem);
        }
        this.configItemStack.add(this.currentConfigItem);
        ConfigItem configItemForParent = this.getConfigItemForParentElement();
        if (configItemForParent != null) {
            if (xmlSchemaElement.getMaxOccurs() > 1L) {
                ConfigItem configItemForArray = new ConfigItem();
                configItemForArray.setName(this.currentConfigItem.getName());
                configItemForArray.setSchemaRef(xmlSchemaElement.getQName().toString());
                configItemForArray.setType(ConfigItem.Type.ARRAY);
                configItemForArray.getChildren().add(this.currentConfigItem);
                configItemForParent.getChildren().add(configItemForArray);
            } else {
                configItemForParent.getChildren().add(this.currentConfigItem);
            }
        }
    }

    private ConfigItem getConfigItemForParentElement() {
        if (this.configItemStack.size() < 2) {
            return null;
        }
        return this.configItemStack.get(this.configItemStack.size() - 2);
    }

    @Override
    public void onExitElement(XmlSchemaElement xmlSchemaElement, XmlSchemaTypeInfo xmlSchemaTypeInfo, boolean b) {
        this.configItemStack.remove(this.configItemStack.size() - 1);
    }

    @Override
    public void onVisitAttribute(XmlSchemaElement xmlSchemaElement, XmlSchemaAttrInfo xmlSchemaAttrInfo) {
        this.currentConfigItem.getChildren().add(this.getConfigItemForAttribute(xmlSchemaAttrInfo));
        if (this.currentConfigItem.isPrimitiveType()) {
            ConfigItem child = new ConfigItem();
            String bodyName = this.elementNameToValueNameMap.get(this.currentConfigItem.getName());
            child.setName(bodyName != null ? bodyName : this.currentConfigItem.getName());
            child.setType(this.currentConfigItem.getType());
            child.setSchemaRef(this.currentConfigItem.getSchemaRef());
            child.setRequired(this.currentConfigItem.isRequired());
            this.currentConfigItem.setType(ConfigItem.Type.OBJECT);
            this.currentConfigItem.setSchemaRef("");
            this.currentConfigItem.getChildren().add(child);
        }
    }

    private void handleEnumerationRestrictions(ConfigItem item, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        List<XmlSchemaRestriction> enumerationFacets = facets.get(XmlSchemaRestriction.Type.ENUMERATION);
        if (enumerationFacets != null && !enumerationFacets.isEmpty()) {
            List enumValues = enumerationFacets.stream().map(e -> (String)e.getValue()).collect(Collectors.toList());
            item.setEnumValues(enumValues);
        }
    }

    private void handlePatternRestrictions(ConfigItem item, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        XmlSchemaRestriction restriction;
        Object obj;
        List<XmlSchemaRestriction> patternFacets = facets.get(XmlSchemaRestriction.Type.PATTERN);
        if (patternFacets != null && !patternFacets.isEmpty() && (obj = (restriction = patternFacets.get(0)).getValue()) instanceof String) {
            if ((item.getType() == ConfigItem.Type.INTEGER || item.getType() == ConfigItem.Type.LONG || item.getType() == ConfigItem.Type.NUMBER || item.getType() == ConfigItem.Type.POSITIVE_INTEGER || item.getType() == ConfigItem.Type.NEGATIVE_INTEGER || item.getType() == ConfigItem.Type.NON_NEGATIVE_INTEGER) && "[\\-+]?[0-9]+".equals(obj)) {
                return;
            }
            item.setPattern((String)obj);
        }
    }

    private void handleStringRestrictions(ConfigItem item, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        XmlSchemaRestriction maxRestriction;
        Object minVal;
        List<XmlSchemaRestriction> maxLengthFacets;
        XmlSchemaRestriction minRestriction;
        Object minVal2;
        List<XmlSchemaRestriction> minLengthFacets = facets.get(XmlSchemaRestriction.Type.LENGTH_MIN);
        if (minLengthFacets != null && !minLengthFacets.isEmpty() && (minVal2 = (minRestriction = minLengthFacets.get(0)).getValue()) instanceof String) {
            item.setMin(Long.valueOf((String)minVal2));
        }
        if ((maxLengthFacets = facets.get(XmlSchemaRestriction.Type.LENGTH_MAX)) != null && !maxLengthFacets.isEmpty() && (minVal = (maxRestriction = maxLengthFacets.get(0)).getValue()) instanceof String) {
            item.setMax(Long.valueOf((String)minVal));
        }
    }

    private void handleOtherRestrictions(ConfigItem item, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        XmlSchemaRestriction minExclusiveRestriction;
        Object minExclusiveVal;
        List<XmlSchemaRestriction> minExclusiveFacets;
        XmlSchemaRestriction maxExclusiveRestriction;
        Object maxExclusiveVal;
        List<XmlSchemaRestriction> maxExclusiveFacets;
        XmlSchemaRestriction maxRestriction;
        Object maxVal;
        List<XmlSchemaRestriction> maxFacets;
        XmlSchemaRestriction minRestriction;
        Object minVal;
        List<XmlSchemaRestriction> minFacets = facets.get(XmlSchemaRestriction.Type.INCLUSIVE_MIN);
        if (minFacets != null && !minFacets.isEmpty() && (minVal = (minRestriction = minFacets.get(0)).getValue()) instanceof String) {
            item.setMin(Long.valueOf((String)minVal));
        }
        if ((maxFacets = facets.get(XmlSchemaRestriction.Type.INCLUSIVE_MAX)) != null && !maxFacets.isEmpty() && (maxVal = (maxRestriction = maxFacets.get(0)).getValue()) instanceof String) {
            item.setMax(Long.valueOf((String)maxVal));
        }
        if ((maxExclusiveFacets = facets.get(XmlSchemaRestriction.Type.EXCLUSIVE_MAX)) != null && !maxExclusiveFacets.isEmpty() && (maxExclusiveVal = (maxExclusiveRestriction = maxExclusiveFacets.get(0)).getValue()) instanceof String) {
            item.setMaxExclusive(true);
            item.setMax(Long.valueOf((String)maxExclusiveVal));
        }
        if ((minExclusiveFacets = facets.get(XmlSchemaRestriction.Type.EXCLUSIVE_MIN)) != null && !minExclusiveFacets.isEmpty() && (minExclusiveVal = (minExclusiveRestriction = minExclusiveFacets.get(0)).getValue()) instanceof String) {
            item.setMinExclusive(true);
            item.setMin(Long.valueOf((String)minExclusiveVal));
        }
    }

    private void setRestrictions(ConfigItem item, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        if (facets == null) {
            return;
        }
        this.handlePatternRestrictions(item, facets);
        this.handleEnumerationRestrictions(item, facets);
        if (item.getType() == ConfigItem.Type.STRING) {
            this.handleStringRestrictions(item, facets);
        } else {
            this.handleOtherRestrictions(item, facets);
        }
    }

    private XmlSchemaElement getElementOf(XmlSchemaCollection collection, String name) {
        XmlSchema schema;
        XmlSchemaElement elem = null;
        XmlSchema[] xmlSchemaArray = collection.getXmlSchemas();
        int n = xmlSchemaArray.length;
        for (int i = 0; i < n && (elem = (schema = xmlSchemaArray[i]).getElementByName(name)) == null; ++i) {
        }
        return elem;
    }

    public String getDocumentation(XmlSchemaAnnotation xmlSchemaAnnotation) {
        if (xmlSchemaAnnotation != null) {
            for (XmlSchemaAnnotationItem item : xmlSchemaAnnotation.getItems()) {
                XmlSchemaDocumentation doc;
                if (!(item instanceof XmlSchemaDocumentation) || (doc = (XmlSchemaDocumentation)item).getMarkup() == null) continue;
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < doc.getMarkup().getLength(); ++i) {
                    sb.append(doc.getMarkup().item(i).getNodeValue());
                }
                return sb.toString();
            }
        }
        return null;
    }

    public ConfigItem getConfigItemForAttribute(XmlSchemaAttrInfo xmlSchemaAttrInfo) {
        ConfigItem configItem = new ConfigItem();
        configItem.setName(xmlSchemaAttrInfo.getAttribute().getName());
        if (xmlSchemaAttrInfo.getAttribute().getAnnotation() != null) {
            configItem.setDocumentation(this.getDocumentation(xmlSchemaAttrInfo.getAttribute().getAnnotation()));
        } else if (xmlSchemaAttrInfo.getAttribute().getSchemaType().getAnnotation() != null) {
            configItem.setDocumentation(this.getDocumentation(xmlSchemaAttrInfo.getAttribute().getSchemaType().getAnnotation()));
        }
        configItem.setType(this.getTypeForAttribute(xmlSchemaAttrInfo));
        configItem.setRequired("REQUIRED".equals(xmlSchemaAttrInfo.getAttribute().getUse().name()));
        configItem.setDefaultValue((Object)xmlSchemaAttrInfo.getAttribute().getDefaultValue());
        configItem.setSchemaRef(xmlSchemaAttrInfo.getAttribute().getQName().toString());
        if (xmlSchemaAttrInfo.getType() != null) {
            this.setRestrictions(configItem, xmlSchemaAttrInfo.getType().getFacets());
        }
        return configItem;
    }

    public ConfigItem.Type getTypeForAttribute(XmlSchemaAttrInfo xmlSchemaAttrInfo) {
        String strType;
        ConfigItem.Type type = null;
        if (xmlSchemaAttrInfo.getAttribute().getSchemaType() != null && xmlSchemaAttrInfo.getAttribute().getSchemaType().getQName() != null) {
            strType = xmlSchemaAttrInfo.getAttribute().getSchemaType().getQName().getLocalPart().toLowerCase();
            type = this.getConfigType(strType);
        }
        if ((ConfigItem.Type.OBJECT == type || type == null) && xmlSchemaAttrInfo.getType() != null) {
            strType = xmlSchemaAttrInfo.getType().getBaseType().name().toLowerCase();
            type = this.getConfigType(strType);
        }
        return type != null ? type : ConfigItem.Type.STRING;
    }

    private ConfigItem.Type getConfigType(String type) {
        switch (type.toLowerCase()) {
            case "double": 
            case "decimal": {
                return ConfigItem.Type.NUMBER;
            }
            case "string": 
            case "id": 
            case "idref": 
            case "token": 
            case "anysimpletype": {
                return ConfigItem.Type.STRING;
            }
            case "boolean": {
                return ConfigItem.Type.BOOLEAN;
            }
            case "integer": 
            case "int": 
            case "short": {
                return ConfigItem.Type.INTEGER;
            }
            case "long": {
                return ConfigItem.Type.LONG;
            }
            case "positiveinteger": {
                return ConfigItem.Type.POSITIVE_INTEGER;
            }
            case "negativeinteger": {
                return ConfigItem.Type.NEGATIVE_INTEGER;
            }
            case "nonnegativeinteger": 
            case "unsignedbyte": 
            case "unsignedshort": 
            case "unsignedint": {
                return ConfigItem.Type.NON_NEGATIVE_INTEGER;
            }
            case "date": {
                return ConfigItem.Type.DATE;
            }
            case "datetime": {
                return ConfigItem.Type.DATE_TIME;
            }
        }
        return ConfigItem.Type.OBJECT;
    }
}

