/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.config.upgrade;

import java.util.Objects;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.opennms.config.upgrade.LiquibaseUpgrader;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class UpgradeConfigService
implements InitializingBean {
    private final ConfigurationManagerService cm;
    private final DataSource dataSource;
    private final boolean skipConfigUpgrades;

    @Inject
    public UpgradeConfigService(ConfigurationManagerService cm, DataSource dataSource, @Value(value="${skipConfigUpgrades:false}") boolean skipConfigUpgrades) {
        this.cm = Objects.requireNonNull(cm);
        this.dataSource = Objects.requireNonNull(dataSource);
        this.skipConfigUpgrades = skipConfigUpgrades;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.skipConfigUpgrades) {
            new LiquibaseUpgrader(this.cm).runChangelog("changelog-cm/changelog-cm.xml", this.dataSource.getConnection());
        }
    }
}

