/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import liquibase.exception.ValidationErrors;
import liquibase.util.file.FilenameUtils;
import org.opennms.features.config.exception.ConfigIOException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

class ConfigFileUtil {
    public static String OPENNMS_HOME = System.getProperty("opennms.home", "");

    ConfigFileUtil() {
    }

    static Path validateAndGetArchiveDir(ValidationErrors validationErrors) {
        Path archivePath = Paths.get(OPENNMS_HOME, "etc_archive");
        try {
            if (!Files.exists(archivePath, new LinkOption[0])) {
                Files.createDirectory(archivePath, new FileAttribute[0]);
            }
            if (!Files.isDirectory(archivePath, new LinkOption[0])) {
                validationErrors.addError(String.format("Archive directory %s is not a directory.", archivePath));
            }
            if (!Files.isWritable(archivePath)) {
                validationErrors.addError(String.format("Archive directory %s is not writable.", archivePath));
            }
        }
        catch (Exception e) {
            validationErrors.addError(String.format("Can not find or create archive directory %s: %s", archivePath, e.getMessage()));
        }
        return archivePath;
    }

    static Collection<Resource> findConfigFiles(String fileName) {
        HashMap<String, Resource> allConfigFiles = new HashMap<String, Resource>();
        String resourcePattern = String.format("classpath*:/defaults/%s", fileName);
        allConfigFiles.putAll(ConfigFileUtil.findFiles(resourcePattern));
        resourcePattern = String.format("file:%s/etc/%s", OPENNMS_HOME, fileName);
        allConfigFiles.putAll(ConfigFileUtil.findFiles(resourcePattern));
        return allConfigFiles.values();
    }

    static Map<String, Resource> findFiles(String resourcePattern) {
        HashMap<String, Resource> configs = new HashMap<String, Resource>();
        try {
            Resource[] configFiles;
            for (Resource config : configFiles = new PathMatchingResourcePatternResolver().getResources(resourcePattern)) {
                if (!config.isReadable()) continue;
                configs.put(config.getFilename(), config);
            }
        }
        catch (IOException e) {
            throw new ConfigIOException("An Exception occurred while trying to find files for " + resourcePattern, (Throwable)e);
        }
        return configs;
    }

    static void checkFileType(ValidationErrors validationErrors, Set<String> allowedExtension, String filePath) {
        Objects.requireNonNull(validationErrors);
        Objects.requireNonNull(allowedExtension);
        if (filePath == null) {
            return;
        }
        String fileType = FilenameUtils.getExtension((String)filePath).toLowerCase();
        if (!allowedExtension.contains(fileType)) {
            validationErrors.addError(String.format("Unknown file type: '%s'", fileType));
        }
    }

    static String asString(Resource resource) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8);){
            String string = FileCopyUtils.copyToString((Reader)reader);
            return string;
        }
    }
}

