/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.api.reporting.ReportException;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Order;
import org.opennms.core.logging.Logging;
import org.opennms.features.reporting.model.basicreport.BasicReportDefinition;
import org.opennms.features.reporting.repository.global.GlobalReportRepository;
import org.opennms.netmgt.dao.api.ReportCatalogDao;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportStoreService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReportStoreService
implements ReportStoreService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReportStoreService.class);
    private ReportCatalogDao m_reportCatalogDao;
    private ReportServiceLocator m_reportServiceLocator;
    private GlobalReportRepository m_globalReportRepository;
    private static final String LOG4J_CATEGORY = "reports";

    @Override
    public void delete(Integer[] ids) {
        for (Integer id : ids) {
            this.delete(id);
        }
    }

    @Override
    public void delete(final Integer id) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                String deleteFile = ((ReportCatalogEntry)DefaultReportStoreService.this.m_reportCatalogDao.get((Serializable)id)).getLocation();
                boolean success = new File(deleteFile).delete();
                if (success) {
                    LOG.debug("deleted report XML file: {}", (Object)deleteFile);
                } else {
                    LOG.warn("unable to delete report XML file: {} will delete reportCatalogEntry anyway", (Object)deleteFile);
                }
                DefaultReportStoreService.this.m_reportCatalogDao.delete(id);
            }
        });
    }

    @Override
    public List<ReportCatalogEntry> getAll() {
        Criteria onmsCrit = new Criteria(ReportCatalogEntry.class);
        onmsCrit.setOrders(Arrays.asList(Order.desc((String)"date")));
        return this.m_reportCatalogDao.findMatching(onmsCrit);
    }

    @Override
    public long countAll() {
        return this.m_reportCatalogDao.countAll();
    }

    @Override
    public List<ReportCatalogEntry> getPage(int offset, int limit) {
        Criteria criteria = new Criteria(ReportCatalogEntry.class);
        criteria.setOrders((Collection)Lists.newArrayList((Object[])new Order[]{Order.desc((String)"date")}));
        criteria.setOffset(Integer.valueOf(offset));
        criteria.setLimit(Integer.valueOf(limit));
        return this.m_reportCatalogDao.findMatching(criteria);
    }

    @Override
    public Map<String, Object> getFormatMap() {
        HashMap<String, Object> formatMap = new HashMap<String, Object>();
        for (BasicReportDefinition report : this.m_globalReportRepository.getAllReports()) {
            List formats = this.m_reportServiceLocator.getReportService(report.getReportService()).getFormats(report.getId());
            formatMap.put(report.getId(), formats);
        }
        return formatMap;
    }

    @Override
    public void render(final Integer id, final ReportFormat format, final OutputStream outputStream) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                ReportCatalogEntry catalogEntry = (ReportCatalogEntry)DefaultReportStoreService.this.m_reportCatalogDao.get((Serializable)id);
                String reportServiceName = DefaultReportStoreService.this.m_globalReportRepository.getReportService(catalogEntry.getReportId());
                ReportService reportService = DefaultReportStoreService.this.m_reportServiceLocator.getReportService(reportServiceName);
                LOG.debug("attempting to rended the report as {} using {}", (Object)reportServiceName, (Object)format);
                try {
                    reportService.render(catalogEntry.getReportId(), catalogEntry.getLocation(), format, outputStream);
                }
                catch (ReportException e) {
                    LOG.error("unable to render report " + id, (Throwable)e);
                }
            }
        });
    }

    @Override
    public void save(ReportCatalogEntry reportCatalogEntry) {
        this.m_reportCatalogDao.save((Object)reportCatalogEntry);
        this.m_reportCatalogDao.flush();
    }

    @Override
    public void setReportCatalogDao(ReportCatalogDao reportCatalogDao) {
        this.m_reportCatalogDao = reportCatalogDao;
    }

    @Override
    public void setReportServiceLocator(ReportServiceLocator reportServiceLocator) {
        this.m_reportServiceLocator = reportServiceLocator;
    }

    public void setGlobalReportRepository(GlobalReportRepository globalReportRepository) {
        this.m_globalReportRepository = globalReportRepository;
    }
}

