/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.client.api.domain.input;

import com.atlassian.jira.rest.client.api.domain.input.CannotTransformValueException;
import com.atlassian.jira.rest.client.api.domain.input.ValueTransformer;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

public class ValueTransformerManager
implements Function<Object, Object> {
    public final List<ValueTransformer> valueTransformers = Lists.newArrayList();

    public ValueTransformerManager registerTransformer(ValueTransformer transformer) {
        this.valueTransformers.add(transformer);
        return this;
    }

    public ValueTransformerManager registerTransformerAsFirst(ValueTransformer transformer) {
        this.valueTransformers.add(0, transformer);
        return this;
    }

    @Override
    public Object apply(@Nullable Object rawInput) {
        if (rawInput instanceof Iterable) {
            Iterable rawInputObjects = (Iterable)rawInput;
            return ImmutableList.copyOf(Iterables.transform(rawInputObjects, this));
        }
        for (ValueTransformer valueTransformer : this.valueTransformers) {
            Object transformedValue = valueTransformer.apply(rawInput);
            if (ValueTransformer.CANNOT_HANDLE.equals(transformedValue)) continue;
            return transformedValue;
        }
        throw new CannotTransformValueException("Any of available transformers was able to transform given value. Value is: " + (rawInput == null ? "NULL" : rawInput.getClass().getName() + ": " + rawInput.toString()));
    }
}

