/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing.persisting;

import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.time.Duration;
import java.util.Collection;
import java.util.Objects;
import org.opennms.integration.api.v1.flows.Flow;
import org.opennms.integration.api.v1.flows.FlowException;
import org.opennms.integration.api.v1.flows.FlowRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchedFlowRepository
implements FlowRepository {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchedFlowRepository.class);
    private final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    private final FlowRepository delegate;
    private boolean enabled = true;

    public SwitchedFlowRepository(FlowRepository delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public void persist(Collection<? extends Flow> flows) throws FlowException {
        if (!this.enabled) {
            this.RATE_LIMITED_LOGGER.info("Flow persistence disabled for {}. Dropping {} flow documents.", (Object)this.delegate, (Object)flows.size());
            return;
        }
        this.delegate.persist(flows);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void setDisabled(boolean disabled) {
        this.enabled = !disabled;
    }
}

