/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.security;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jolokia.osgi.security.Authenticator;
import org.jolokia.osgi.security.DefaultHttpContext;
import org.jolokia.osgi.util.LogHelper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceAuthenticationHttpContext
extends DefaultHttpContext {
    static final String AUTHMODE_SERVICE_ALL = "service-all";
    static final String AUTHMODE_SERVICE_ANY = "service-any";
    private final Set<Authenticator> authenticators = new HashSet<Authenticator>();
    private ServiceTracker authenticatorServiceTracker;
    private final boolean checkModeAny;

    public ServiceAuthenticationHttpContext(BundleContext bundleContext, String authMode) {
        if (!ServiceAuthenticationHttpContext.shouldBeUsed(authMode)) {
            throw new IllegalArgumentException(String.format("Internal: Invalid authMode %s given", authMode));
        }
        this.checkModeAny = authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ANY);
        this.authenticatorServiceTracker = new ServiceTracker(bundleContext, Authenticator.class.getName(), (ServiceTrackerCustomizer)new AuthenticatorServiceCustomizer(bundleContext));
        this.authenticatorServiceTracker.open();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleSecurity(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Set<Authenticator> set = this.authenticators;
        synchronized (set) {
            if (this.authenticators.isEmpty()) {
                response.sendError(401);
                return false;
            }
            for (Authenticator authenticator : this.authenticators) {
                boolean authenticated = authenticator.authenticate(request);
                if (this.checkModeAny && authenticated) {
                    return true;
                }
                if (this.checkModeAny || authenticated) continue;
                response.sendError(401);
                return false;
            }
            return !this.checkModeAny;
        }
    }

    public void close() {
        if (this.authenticatorServiceTracker != null) {
            this.authenticatorServiceTracker.close();
            this.authenticatorServiceTracker = null;
        }
    }

    public static boolean shouldBeUsed(String authMode) {
        return authMode != null && (authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ALL) || authMode.equalsIgnoreCase(AUTHMODE_SERVICE_ANY));
    }

    private class AuthenticatorServiceCustomizer
    implements ServiceTrackerCustomizer {
        private final BundleContext bundleContext;

        AuthenticatorServiceCustomizer(BundleContext bundleContext) {
            this.bundleContext = bundleContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object addingService(ServiceReference serviceReference) {
            Object service = this.bundleContext.getService(serviceReference);
            try {
                Set set = ServiceAuthenticationHttpContext.this.authenticators;
                synchronized (set) {
                    ServiceAuthenticationHttpContext.this.authenticators.add((Authenticator)service);
                    return ServiceAuthenticationHttpContext.this.authenticators;
                }
            }
            catch (ClassCastException e) {
                LogHelper.logError("Unable to use provided Authenticator", e);
                return null;
            }
        }

        public void modifiedService(ServiceReference serviceReference, Object service) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removedService(ServiceReference serviceReference, Object service) {
            Set set = ServiceAuthenticationHttpContext.this.authenticators;
            synchronized (set) {
                this.bundleContext.ungetService(serviceReference);
                ServiceAuthenticationHttpContext.this.authenticators.remove(service);
            }
        }
    }
}

