/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.reporting.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.netmgt.config.reportd.Parameter;
import org.opennms.netmgt.config.reportd.Report;
import org.opennms.netmgt.dao.api.ReportCatalogDao;
import org.opennms.netmgt.model.ReportCatalogEntry;
import org.opennms.netmgt.reporting.service.ReportRunException;
import org.opennms.netmgt.reporting.service.ReportService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultReportService
implements ReportService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReportService.class);
    private ReportCatalogDao m_reportCatalogDao;

    @Override
    public synchronized String runReport(Report report, String reportDirectory) throws ReportRunException {
        String outputFile = null;
        try {
            outputFile = this.generateReportName(reportDirectory, report.getReportName(), report.getReportFormat());
            JasperPrint print = this.runAndRender(report);
            outputFile = this.saveReport(print, report, outputFile);
        }
        catch (JRException e) {
            LOG.error("Error running report: {}", (Object)e.getMessage(), (Object)e);
            throw new ReportRunException("Caught JRException: " + e.getMessage());
        }
        catch (Throwable e) {
            LOG.error("Unexpected exception: {}", (Object)e.getMessage(), (Object)e);
            throw new ReportRunException("Caught unexpected " + e.getClass().getName() + ": " + e.getMessage());
        }
        return outputFile;
    }

    public ReportCatalogDao getReportCatalogDao() {
        return this.m_reportCatalogDao;
    }

    public void setReportCatalogDao(ReportCatalogDao reportCatalogDao) {
        this.m_reportCatalogDao = reportCatalogDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_reportCatalogDao, (String)"No Report Catalog DAO set");
    }

    private void createReportCatalogEntry(JasperPrint jasperPrint, Report report, String fileName) throws ReportRunException {
        ReportCatalogEntry catalogEntry = new ReportCatalogEntry();
        catalogEntry.setDate(new Date());
        catalogEntry.setReportId("reportd_" + report.getReportTemplate());
        catalogEntry.setTitle(report.getReportName());
        catalogEntry.setLocation(fileName);
        try {
            this.m_reportCatalogDao.save((Object)catalogEntry);
        }
        catch (Exception e) {
            throw new ReportRunException("Can't save a report catalog entry, " + e.getMessage());
        }
    }

    private String generateReportName(String reportDirectory, String reportName, String reportFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yyyyMMddHHmmss");
        return reportDirectory + reportName + sdf.format(new Date()) + "." + reportFormat;
    }

    private String saveReport(JasperPrint jasperPrint, Report report, String destFileName) throws JRException, Exception {
        this.createReportCatalogEntry(jasperPrint, report, destFileName);
        String reportName = null;
        switch (Format.valueOf(report.getReportFormat())) {
            case pdf: {
                JasperExportManager.exportReportToPdfFile((JasperPrint)jasperPrint, (String)destFileName);
                reportName = destFileName;
                break;
            }
            case html: {
                JasperExportManager.exportReportToHtmlFile((JasperPrint)jasperPrint, (String)destFileName);
                reportName = this.createZip(destFileName);
                break;
            }
            case xml: {
                JasperExportManager.exportReportToXmlFile((JasperPrint)jasperPrint, (String)destFileName, (boolean)true);
                reportName = this.createZip(destFileName);
                break;
            }
            case csv: {
                JRCsvExporter exporter = new JRCsvExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destFileName);
                exporter.exportReport();
                reportName = destFileName;
                break;
            }
            default: {
                LOG.error("Error Running Report: Unknown Format: {}", (Object)report.getReportFormat());
            }
        }
        return reportName;
    }

    private JasperPrint runAndRender(Report report) throws Exception, JRException {
        JasperPrint jasperPrint = new JasperPrint();
        JasperReport jasperReport = JasperCompileManager.compileReport((String)(System.getProperty("opennms.home") + File.separator + "etc" + File.separator + "report-templates" + File.separator + report.getReportTemplate()));
        if (report.getReportEngine().equals("jdbc")) {
            Connection connection = DataSourceFactory.getInstance().getConnection();
            jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, this.paramListToMap(report.getParameters()), (Connection)connection);
            connection.close();
        } else if (report.getReportEngine().equals("opennms")) {
            LOG.error("Sorry the OpenNMS Data source engine is not yet available");
            jasperPrint = null;
        } else {
            LOG.error("Unknown report engine: {} ", (Object)report.getReportEngine());
            jasperPrint = null;
        }
        return jasperPrint;
    }

    private String createZip(String baseFileName) {
        File reportResourceDirectory = new File(baseFileName + "_files");
        String zipFile = baseFileName + ".zip";
        if (reportResourceDirectory.exists() && reportResourceDirectory.isDirectory()) {
            try {
                ZipOutputStream reportArchive = new ZipOutputStream(new FileOutputStream(zipFile));
                this.addFileToArchive(reportArchive, baseFileName);
                reportArchive.putNextEntry(new ZipEntry(baseFileName));
                for (String file : Arrays.asList(reportResourceDirectory.list())) {
                    this.addFileToArchive(reportArchive, file);
                }
                reportArchive.close();
            }
            catch (Exception e) {
                LOG.warn("unable to create {}", (Object)zipFile, (Object)e);
            }
        }
        return zipFile;
    }

    private void addFileToArchive(ZipOutputStream reportArchive, String file) throws FileNotFoundException, IOException {
        int len;
        FileInputStream asf = new FileInputStream(file);
        reportArchive.putNextEntry(new ZipEntry(file));
        byte[] buffer = new byte[18024];
        while ((len = asf.read(buffer)) > 0) {
            reportArchive.write(buffer, 0, len);
        }
        asf.close();
        reportArchive.closeEntry();
    }

    private Map<String, Object> paramListToMap(List<Parameter> parameters) {
        HashMap<String, Object> parmMap = new HashMap<String, Object>();
        for (Parameter parm : parameters) {
            parmMap.put(parm.getName(), parm.getValue());
        }
        return parmMap;
    }

    private static enum Format {
        pdf,
        html,
        xml,
        xls,
        csv;

    }
}

