/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.client.request.J4pListRequest;
import org.jolokia.client.request.J4pResponse;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public final class J4pListResponse
extends J4pResponse<J4pListRequest> {
    J4pListResponse(J4pListRequest pRequest, JSONObject pJsonResponse) {
        super(pRequest, pJsonResponse);
    }

    public List<ObjectInstance> getObjectInstances(ObjectName name) throws MalformedObjectNameException {
        LinkedList<ObjectInstance> result = new LinkedList<ObjectInstance>();
        Map value = (Map)this.getValue();
        if (value.containsKey("class")) {
            return Collections.singletonList(new ObjectInstance(name, this.getClassName()));
        }
        ArrayList instances = new ArrayList(value.size());
        for (Map.Entry domain : value.entrySet()) {
            for (Map.Entry qualifier : ((Map)domain.getValue()).entrySet()) {
                result.add(new ObjectInstance(new ObjectName((String)domain.getKey() + ":" + (String)qualifier.getKey()), (String)((Map)qualifier.getValue()).get("class")));
            }
        }
        return result;
    }

    public MBeanInfo getMbeanInfo() throws InstanceNotFoundException {
        JSONObject value = (JSONObject)this.getValue();
        if (value.containsKey((Object)"class")) {
            return this.mBeanInfoFrom(value);
        }
        throw new InstanceNotFoundException();
    }

    private MBeanInfo mBeanInfoFrom(JSONObject value) {
        return new MBeanInfo("" + value.get((Object)"class"), "" + value.get((Object)"desc"), this.attributesFrom((Map)value.get((Object)"attr")), new MBeanConstructorInfo[0], this.operationsFrom((Map)value.get((Object)"op")), new MBeanNotificationInfo[0]);
    }

    private MBeanOperationInfo[] operationsFrom(Map<String, Map<String, Object>> operations) {
        if (operations == null) {
            return new MBeanOperationInfo[0];
        }
        ArrayList<MBeanOperationInfo> result = new ArrayList<MBeanOperationInfo>(operations.size());
        for (Map.Entry<String, Map<String, Object>> operation : operations.entrySet()) {
            if (operation.getValue() instanceof JSONArray) {
                for (Object operationItem : (JSONArray)operation.getValue()) {
                    result.add(this.operationFrom(operation.getKey(), (Map)operationItem));
                }
                continue;
            }
            result.add(this.operationFrom(operation.getKey(), operation.getValue()));
        }
        return result.toArray(new MBeanOperationInfo[0]);
    }

    private MBeanOperationInfo operationFrom(String operationName, Map<String, Object> operation) {
        return new MBeanOperationInfo(operationName, "" + operation.get("desc"), this.getArguments((JSONArray)operation.get("args")), "" + operation.get("ret"), 3);
    }

    private MBeanParameterInfo[] getArguments(JSONArray args) {
        MBeanParameterInfo[] result = new MBeanParameterInfo[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            result[i] = this.parameterInfo((Map)args.get(i));
        }
        return result;
    }

    private MBeanParameterInfo parameterInfo(Map<String, String> parameter) {
        return new MBeanParameterInfo(parameter.get("name"), parameter.get("type"), parameter.get("desc"));
    }

    private MBeanAttributeInfo[] attributesFrom(Map<String, Map<String, Object>> attributes) {
        if (attributes == null) {
            return new MBeanAttributeInfo[0];
        }
        attributes = new TreeMap<String, Map<String, Object>>(attributes);
        MBeanAttributeInfo[] result = new MBeanAttributeInfo[attributes.size()];
        int index = 0;
        for (Map.Entry<String, Map<String, Object>> attribute : attributes.entrySet()) {
            result[index++] = this.attributeFrom(attribute);
        }
        return result;
    }

    private MBeanAttributeInfo attributeFrom(Map.Entry<String, Map<String, Object>> attribute) {
        return new MBeanAttributeInfo(attribute.getKey(), "" + attribute.getValue().get("type"), "" + attribute.getValue().get("desc"), true, Boolean.TRUE == attribute.getValue().get("rw"), false);
    }

    public String getClassName() {
        return (String)((JSONObject)this.getValue()).get((Object)"class");
    }
}

