/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.syslogd.api;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.opennms.core.ipc.sink.api.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogConnection
implements Message {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogConnection.class);
    public static final int MAX_PACKET_SIZE = 4096;
    private final InetSocketAddress source;
    private final ByteBuffer buffer;

    public SyslogConnection(DatagramPacket pkt, boolean copy) {
        this.source = new InetSocketAddress(pkt.getAddress(), pkt.getPort());
        byte[] data = copy ? Arrays.copyOf(pkt.getData(), pkt.getLength()) : pkt.getData();
        this.buffer = ByteBuffer.wrap(data, 0, pkt.getLength());
    }

    public SyslogConnection(InetSocketAddress source, ByteBuffer buffer) {
        this.source = source;
        this.buffer = buffer;
    }

    public InetSocketAddress getSource() {
        return this.source;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public static DatagramPacket copyPacket(DatagramPacket packet) {
        byte[] message = new byte[packet.getLength()];
        System.arraycopy(packet.getData(), 0, message, 0, packet.getLength());
        InetAddress addr = null;
        try {
            addr = InetAddress.getByAddress(packet.getAddress().getHostName(), packet.getAddress().getAddress());
            DatagramPacket retPacket = new DatagramPacket(message, packet.getOffset(), packet.getLength(), addr, packet.getPort());
            return retPacket;
        }
        catch (UnknownHostException e) {
            LOG.warn("unable to clone InetAddress object for {}", (Object)packet.getAddress());
            return null;
        }
    }

    public static DatagramPacket copyPacket(InetAddress sourceAddress, int sourcePort, ByteBuffer buffer) {
        byte[] message = new byte[4096];
        int i = 0;
        while (buffer.hasRemaining()) {
            message[i++] = buffer.get();
        }
        return SyslogConnection.copyPacket(sourceAddress, sourcePort, message, i);
    }

    private static DatagramPacket copyPacket(InetAddress sourceAddress, int sourcePort, byte[] buffer, int length) {
        DatagramPacket retPacket = new DatagramPacket(buffer, 0, length, sourceAddress, sourcePort);
        return retPacket;
    }
}

