/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.concurrent.ThreadFactory;
import org.apache.camel.util.concurrent.CamelThreadFactory;

public final class NettyServerBossPoolBuilder {
    private String name = "NettyServerBoss";
    private String pattern;
    private int bossCount = 1;
    private boolean nativeTransport;

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setBossCount(int bossCount) {
        this.bossCount = bossCount;
    }

    public void setNativeTransport(boolean nativeTransport) {
        this.nativeTransport = nativeTransport;
    }

    public NettyServerBossPoolBuilder withName(String name) {
        this.setName(name);
        return this;
    }

    public NettyServerBossPoolBuilder withPattern(String pattern) {
        this.setPattern(pattern);
        return this;
    }

    public NettyServerBossPoolBuilder withBossCount(int bossCount) {
        this.setBossCount(bossCount);
        return this;
    }

    public NettyServerBossPoolBuilder withNativeTransport(boolean nativeTransport) {
        this.setNativeTransport(nativeTransport);
        return this;
    }

    public EventLoopGroup build() {
        if (this.nativeTransport) {
            return new EpollEventLoopGroup(this.bossCount, (ThreadFactory)new CamelThreadFactory(this.pattern, this.name, false));
        }
        return new NioEventLoopGroup(this.bossCount, (ThreadFactory)new CamelThreadFactory(this.pattern, this.name, false));
    }
}

