/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.protocol;

public enum Protocol {
    ICMP("icmp", Layer.LAYER_3),
    ICMP6("icmp6", Layer.LAYER_3),
    IGMP("igmp", Layer.LAYER_3),
    TLS("tcp", Layer.LAYER_7),
    TCP("tcp", Layer.LAYER_4),
    UDP("udp", Layer.LAYER_4),
    SCTP("sctp", Layer.LAYER_4),
    SIP("sip", Layer.LAYER_7),
    SDP("sdp", Layer.LAYER_7),
    ETHERNET_II("eth", Layer.LAYER_2, 1L),
    SLL("sll", Layer.LAYER_2, 113L),
    IPv4("ip", Layer.LAYER_3, 101L),
    IPv6("ipv6", Layer.LAYER_3, 229L),
    PCAP("pcap", Layer.LAYER_1),
    RTP("rtp", Layer.LAYER_7),
    RTCP("rtcp", Layer.LAYER_7),
    ARP("arp", Layer.LAYER_3),
    UNKNOWN("unknown", null);

    private final String name;
    private final Layer layer;
    private Long linkType = null;

    private Protocol(String name, Layer layer) {
        this.name = name;
        this.layer = layer;
    }

    private Protocol(String name, Layer layer, Long linkType) {
        this.name = name;
        this.layer = layer;
        this.linkType = linkType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public Layer getProtocolLayer() {
        return this.layer;
    }

    public static Protocol valueOf(byte code) {
        switch (code) {
            case 1: {
                return ICMP;
            }
            case 2: {
                return IGMP;
            }
            case 6: {
                return TCP;
            }
            case 17: {
                return UDP;
            }
            case -124: {
                return SCTP;
            }
            case 58: {
                return ICMP6;
            }
        }
        return null;
    }

    public Long getLinkType() {
        return this.linkType;
    }

    public static enum Layer {
        LAYER_1,
        LAYER_2,
        LAYER_3,
        LAYER_4,
        LAYER_7;

    }
}

