/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.IPPacket;
import io.pkts.packet.IPv4Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.UDPPacket;
import io.pkts.packet.impl.TransportPacketImpl;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.OutputStream;

public final class UdpPacketImpl
extends TransportPacketImpl
implements UDPPacket {
    private final Buffer headers;

    public UdpPacketImpl(IPPacket parent, Buffer headers, Buffer payload) {
        super(parent, Protocol.UDP, headers, payload);
        this.headers = headers;
    }

    @Override
    public boolean isUDP() {
        return true;
    }

    @Override
    public int getHeaderLength() {
        return this.headers.capacity();
    }

    @Override
    public int getLength() {
        return this.headers.getUnsignedShort(4);
    }

    public void setLength(int length) {
        this.headers.setUnsignedShort(4, length);
    }

    @Override
    public int getChecksum() {
        return this.headers.getUnsignedShort(6);
    }

    @Override
    public TransportPacket clone() {
        IPPacket parent = this.getParentPacket().clone();
        return new UdpPacketImpl(parent, this.headers.clone(), this.getPayload().clone());
    }

    @Override
    public final void write(OutputStream out, Buffer payload) throws IOException {
        int size = this.headers.getReadableBytes() + (payload != null ? payload.getReadableBytes() : 0);
        this.setLength(size);
        IPPacket parent = this.getParentPacket();
        if (parent instanceof IPv4Packet) {
            ((IPv4Packet)parent).reCalculateChecksum();
        }
        Buffer pkt = Buffers.wrap((Buffer)this.headers, (Buffer)payload);
        this.getParentPacket().write(out, pkt);
    }
}

