/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.flows.api.ConversationKey;
import org.opennms.netmgt.flows.api.Host;

public class Conversation {
    private final String location;
    private final Integer protocol;
    private final Host lowerHost;
    private final Host upperHost;
    private final String application;

    private Conversation(Builder builder) {
        this.location = Objects.requireNonNull(builder.location);
        this.protocol = Objects.requireNonNull(builder.protocol);
        this.lowerHost = builder.lowerHost.build();
        this.upperHost = builder.upperHost.build();
        this.application = builder.application;
    }

    public String getLocation() {
        return this.location;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public Host getLowerHost() {
        return this.lowerHost;
    }

    public String getLowerIp() {
        return this.lowerHost.getIp();
    }

    public Optional<String> getLowerHostname() {
        return this.lowerHost.getHostname();
    }

    public Host getUpperHost() {
        return this.upperHost;
    }

    public String getUpperIp() {
        return this.upperHost.getIp();
    }

    public Optional<String> getUpperHostname() {
        return this.upperHost.getHostname();
    }

    public String getApplication() {
        return this.application;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder from(ConversationKey key) {
        return new Builder().withLocation(key.getLocation()).withProtocol(key.getProtocol()).withLowerIp(key.getLowerIp()).withUpperIp(key.getUpperIp()).withApplication(key.getApplication());
    }

    public static Builder from(Conversation convo) {
        return new Builder().withLocation(convo.location).withProtocol(convo.protocol).withLowerHost(Host.from(convo.lowerHost)).withUpperHost(Host.from(convo.upperHost)).withApplication(convo.application);
    }

    public static Builder forOther() {
        return Conversation.builder().withLocation("Other").withProtocol(-1).withLowerHost(Host.forOther()).withUpperHost(Host.forOther()).withApplication("Other");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Conversation)) {
            return false;
        }
        Conversation that = (Conversation)o;
        return Objects.equals(this.location, that.location) && Objects.equals(this.protocol, that.protocol) && Objects.equals(this.lowerHost, that.lowerHost) && Objects.equals(this.upperHost, that.upperHost) && Objects.equals(this.application, that.application);
    }

    public int hashCode() {
        return Objects.hash(this.location, this.protocol, this.lowerHost, this.upperHost, this.application);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("location", (Object)this.location).add("protocol", (Object)this.protocol).add("lowerHost", (Object)this.lowerHost).add("upperHost", (Object)this.upperHost).add("application", (Object)this.application).toString();
    }

    public static class Builder {
        private String location;
        private Integer protocol;
        private Host.Builder lowerHost = Host.builder();
        private Host.Builder upperHost = Host.builder();
        private String application;

        private Builder() {
        }

        public Builder withLocation(String location) {
            this.location = Objects.requireNonNull(location);
            return this;
        }

        public Builder withProtocol(Integer protocol) {
            this.protocol = Objects.requireNonNull(protocol);
            return this;
        }

        public Builder withLowerHost(Host.Builder lowerHost) {
            this.lowerHost = Objects.requireNonNull(lowerHost);
            return this;
        }

        public Builder withUpperHost(Host.Builder upperHost) {
            this.upperHost = Objects.requireNonNull(upperHost);
            return this;
        }

        public Builder withLowerIp(String lowerIp) {
            this.lowerHost.withIp(lowerIp);
            return this;
        }

        public Builder withUpperIp(String upperIp) {
            this.upperHost.withIp(upperIp);
            return this;
        }

        public Builder withLowerHostname(String hostname) {
            this.lowerHost.withHostname(hostname);
            return this;
        }

        public Builder withUpperHostname(String hostname) {
            this.upperHost.withHostname(hostname);
            return this;
        }

        public Builder withApplication(String application) {
            this.application = application;
            return this;
        }

        public Conversation build() {
            return new Conversation(this);
        }
    }
}

