/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.RowSortedTable;
import java.util.List;
import java.util.ServiceLoader;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterFactory;
import org.opennms.netmgt.measurements.api.exceptions.FilterException;
import org.opennms.netmgt.measurements.model.FilterDef;
import org.opennms.netmgt.measurements.model.FilterMetaData;
import org.springframework.stereotype.Component;

@Component(value="filterEngine")
public class FilterEngine {
    private static final ServiceLoader<FilterFactory> filterFactories = ServiceLoader.load(FilterFactory.class);
    private List<FilterMetaData> filterMetaDatas = null;

    public void filter(FilterDef filterDef, RowSortedTable<Long, String, Double> table) throws Exception {
        Preconditions.checkNotNull((Object)filterDef, (Object)"filterDef argument");
        Preconditions.checkNotNull(table, (Object)"table argument");
        this.filter(Lists.newArrayList((Object[])new FilterDef[]{filterDef}), table);
    }

    public void filter(List<FilterDef> filterDefinitions, RowSortedTable<Long, String, Double> table) throws FilterException {
        Preconditions.checkNotNull(filterDefinitions, (Object)"filterDefinitions argument");
        Preconditions.checkNotNull(table, (Object)"table argument");
        for (FilterDef filterDef : filterDefinitions) {
            Filter filter = this.getFilter(filterDef);
            if (filter == null) {
                throw new FilterException("No filter implementation found for {}", filterDef.getName());
            }
            try {
                filter.filter(table);
            }
            catch (Throwable t) {
                throw new FilterException(t, "An error occurred while applying filter {}", t.getMessage());
            }
        }
    }

    private Filter getFilter(FilterDef filterDef) {
        for (FilterFactory module : filterFactories) {
            Filter filter = module.getFilter(filterDef);
            if (filter == null) continue;
            return filter;
        }
        return null;
    }

    public synchronized List<FilterMetaData> getFilterMetaData() {
        if (this.filterMetaDatas != null) {
            return this.filterMetaDatas;
        }
        this.filterMetaDatas = Lists.newArrayList();
        for (FilterFactory module : filterFactories) {
            this.filterMetaDatas.add(new FilterMetaData(module.getFilterType()));
        }
        return this.filterMetaDatas;
    }

    public FilterMetaData getFilterMetaData(String filterName) {
        for (FilterMetaData metaData : this.getFilterMetaData()) {
            if (!metaData.getName().equalsIgnoreCase(filterName) && !metaData.getCanonicalName().equals(filterName)) continue;
            return metaData;
        }
        return null;
    }
}

