/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.config.snmp;


import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.opennms.core.xml.ValidateUsing;

@XmlRootElement(name="profiles")
@XmlAccessorType(XmlAccessType.NONE)
@ValidateUsing("snmp-config.xsd")
public class SnmpProfiles {

    @XmlElement(name="profile")
    private List<SnmpProfile> snmpProfiles = new ArrayList<>();

    public List<SnmpProfile> getSnmpProfiles() {
        return snmpProfiles;
    }

    public void setSnmpProfiles(List<SnmpProfile> snmpProfiles) {
        this.snmpProfiles = snmpProfiles;
    }

    public void addSnmpProfile(SnmpProfile snmpProfile) {
        this.snmpProfiles.add(snmpProfile);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SnmpProfiles that = (SnmpProfiles) o;
        return Objects.equals(snmpProfiles, that.snmpProfiles);
    }

    @Override
    public int hashCode() {
        return Objects.hash(snmpProfiles);
    }
}
