/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.flows.elastic;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.opennms.features.jest.client.index.IndexStrategy;
import org.opennms.features.jest.client.index.IndexStrategyFactory;

public class IndexStrategyFactoryTest {
    @Test
    public void verifyInitialization() {
        // Verify initialization for each IndexStrategy (case matches)
        for (IndexStrategy eachValue : IndexStrategy.values()) {
            assertEquals(eachValue, IndexStrategyFactory.createIndexStrategy(eachValue.name()));
        }

        // Verify Initialization for each IndexStrategy (case does not match)
        // See HZN-1240 for more details
        for (IndexStrategy eachValue : IndexStrategy.values()) {
            assertEquals(eachValue, IndexStrategyFactory.createIndexStrategy(eachValue.name().toLowerCase()));
        }
    }

}