/*
 * Decompiled with CFR 0.152.
 */
package io.takari.filemanager.internal;

import io.takari.filemanager.FileManager;
import io.takari.filemanager.Lock;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.nio.channels.FileLockInterruptionException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultFileManager
implements FileManager {
    private static Boolean IS_SET_LAST_MODIFIED_SAFE;
    private Logger logger = LoggerFactory.getLogger(DefaultFileManager.class);
    private static final ConcurrentMap<File, LockFile> lockFiles;

    static {
        lockFiles = new ConcurrentHashMap<File, LockFile>(64);
    }

    @Override
    public Lock readLock(File target) {
        return new IndirectFileLock(this.normalize(target), false);
    }

    @Override
    public Lock writeLock(File target) {
        return new IndirectFileLock(this.normalize(target), true);
    }

    private File normalize(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            this.logger.warn("Failed to normalize pathname for lock on " + file + ": " + e);
            return file.getAbsoluteFile();
        }
    }

    @Override
    public boolean mkdirs(File directory) {
        if (directory == null) {
            return false;
        }
        return directory.mkdirs();
    }

    /*
     * Unable to fully structure code
     */
    private RandomAccessFile open(File file, String mode) throws IOException {
        interrupted = false;
        try {
            this.mkdirs(file.getParentFile());
            var7_4 = new RandomAccessFile(file, mode);
            return var7_4;
        }
        catch (IOException e) {
            i = 3;
            ** while (i >= 0)
        }
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException v0) {
                interrupted = true;
            }
            try {
                var7_5 = new RandomAccessFile(file, mode);
                return var7_5;
            }
            catch (IOException v1) {
                try {
                    --i;
                    continue;
lbl22:
                    // 1 sources

                    throw e;
                }
                catch (Throwable var6_8) {
                    throw var6_8;
lbl25:
                    // 1 sources

                    ** GOTO lbl22
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void close(Closeable closeable) {
        block3: {
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    if (this.logger == null) break block3;
                    this.logger.warn("Failed to close file: " + e);
                }
            }
        }
    }

    private void unlock(Lock lock) {
        if (lock != null) {
            try {
                lock.unlock();
            }
            catch (IOException e) {
                this.logger.warn("Failed to unlock file " + lock.getFile() + ": " + e);
            }
        }
    }

    @Override
    public void copy(File source, File target) throws IOException {
        this.copy(source, target, null);
    }

    @Override
    public long copy(File source, File target, FileManager.ProgressListener listener) throws IOException {
        Lock sourceLock = this.readLock(source);
        Lock targetLock = this.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            long l = this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), listener);
            return l;
        }
        finally {
            target.setLastModified(source.lastModified());
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }

    private long copy(RandomAccessFile rafIn, RandomAccessFile rafOut, FileManager.ProgressListener listener) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(32768);
        byte[] array = buffer.array();
        long total = 0L;
        while (true) {
            int bytes;
            if ((bytes = rafIn.read(array)) < 0) break;
            rafOut.write(array, 0, bytes);
            total += (long)bytes;
            if (listener == null || bytes <= 0) continue;
            try {
                buffer.rewind();
                buffer.limit(bytes);
                listener.progressed(buffer);
            }
            catch (Exception e) {
                this.logger.debug("Failed to invoke copy progress listener", (Throwable)e);
            }
        }
        rafOut.setLength(rafOut.getFilePointer());
        return total;
    }

    @Override
    public void write(File file, InputStream source) throws IOException {
        Lock lock = this.writeLock(file);
        try {
            this.mkdirs(file.getParentFile());
            lock.lock();
            RandomAccessFile raf = lock.getRandomAccessFile();
            raf.seek(0L);
            if (source != null) {
                int len;
                byte[] buffer = new byte[1024];
                while ((len = source.read(buffer)) != -1) {
                    raf.write(buffer, 0, len);
                }
            }
            raf.setLength(raf.getFilePointer());
        }
        finally {
            this.unlock(lock);
        }
    }

    @Override
    public void write(File file, String data) throws IOException {
        Lock lock = this.writeLock(file);
        try {
            this.mkdirs(file.getParentFile());
            lock.lock();
            RandomAccessFile raf = lock.getRandomAccessFile();
            raf.seek(0L);
            if (data != null) {
                raf.write(data.getBytes("UTF-8"));
            }
            raf.setLength(raf.getFilePointer());
        }
        finally {
            this.unlock(lock);
        }
    }

    @Override
    public void move(File source, File target) throws IOException {
        Lock sourceLock = this.writeLock(source);
        Lock targetLock = this.writeLock(target);
        try {
            this.mkdirs(target.getParentFile());
            sourceLock.lock();
            targetLock.lock();
            if (!source.renameTo(target)) {
                this.copy(sourceLock.getRandomAccessFile(), targetLock.getRandomAccessFile(), null);
                if (IS_SET_LAST_MODIFIED_SAFE == null) {
                    IS_SET_LAST_MODIFIED_SAFE = target.setLastModified(source.lastModified());
                    this.logger.debug("Updates of file modification timestamp are safe: " + IS_SET_LAST_MODIFIED_SAFE);
                }
                this.close(targetLock.getRandomAccessFile());
                if (IS_SET_LAST_MODIFIED_SAFE.booleanValue()) {
                    target.setLastModified(source.lastModified());
                }
                this.close(sourceLock.getRandomAccessFile());
                source.delete();
            }
        }
        finally {
            this.unlock(sourceLock);
            this.unlock(targetLock);
        }
    }

    static /* synthetic */ void access$3(DefaultFileManager defaultFileManager, Closeable closeable) {
        defaultFileManager.close(closeable);
    }

    class IndirectFileLock
    implements Lock {
        private final File file;
        private final boolean write;
        private final Throwable stackTrace;
        private RandomAccessFile raFile;
        private LockFile lockFile;
        private int nesting;

        public IndirectFileLock(File file, boolean write) {
            this.file = file;
            this.write = write;
            this.stackTrace = new IllegalStateException();
        }

        @Override
        public synchronized void lock() throws IOException {
            if (this.lockFile == null) {
                this.open();
                this.nesting = 1;
            } else {
                ++this.nesting;
            }
        }

        @Override
        public synchronized void unlock() throws IOException {
            --this.nesting;
            if (this.nesting <= 0) {
                this.close();
            }
        }

        @Override
        public RandomAccessFile getRandomAccessFile() throws IOException {
            if (this.raFile == null && this.lockFile != null && this.lockFile.getFileLock().isValid()) {
                this.raFile = DefaultFileManager.this.open(this.file, this.write ? "rw" : "r");
            }
            return this.raFile;
        }

        @Override
        public boolean isShared() {
            if (this.lockFile == null) {
                throw new IllegalStateException("lock not acquired");
            }
            return this.lockFile.isShared();
        }

        @Override
        public FileLock getLock() {
            if (this.lockFile == null) {
                return null;
            }
            return this.lockFile.getFileLock();
        }

        @Override
        public File getFile() {
            return this.file;
        }

        protected void finalize() throws Throwable {
            try {
                if (this.lockFile != null) {
                    DefaultFileManager.this.logger.warn("Lock on file " + this.file + " has not been properly released", this.stackTrace);
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }

        private void open() throws IOException {
            this.lockFile = this.lock(this.file, this.write);
        }

        private void close() throws IOException {
            block15: {
                try {
                    if (this.raFile == null) break block15;
                    try {
                        this.raFile.close();
                    }
                    finally {
                        this.raFile = null;
                    }
                }
                finally {
                    block17: {
                        if (this.lockFile != null) {
                            try {
                                try {
                                    this.unlock(this.lockFile);
                                }
                                catch (IOException e) {
                                    DefaultFileManager.this.logger.warn("Failed to release lock for " + this.file + ": " + e);
                                    this.lockFile = null;
                                    break block17;
                                }
                            }
                            catch (Throwable throwable) {
                                this.lockFile = null;
                                throw throwable;
                            }
                            this.lockFile = null;
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private LockFile lock(File file, boolean write) throws IOException {
            boolean interrupted = false;
            try {
                while (true) {
                    LockFile lockFile;
                    if ((lockFile = (LockFile)lockFiles.get(file)) == null) {
                        lockFile = new LockFile(file);
                        LockFile existing = lockFiles.putIfAbsent(file, lockFile);
                        if (existing != null) {
                            lockFile = existing;
                        }
                    }
                    LockFile lockFile2 = lockFile;
                    synchronized (lockFile2) {
                        if (lockFile.isInvalid()) {
                            continue;
                        }
                        if (lockFile.lock(write)) {
                            LockFile lockFile3 = lockFile;
                            return lockFile3;
                        }
                        {
                            try {
                                lockFile.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                interrupted = true;
                            }
                            continue;
                        }
                    }
                    break;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlock(LockFile lockFile) throws IOException {
            LockFile lockFile2 = lockFile;
            synchronized (lockFile2) {
                try {
                    lockFile.unlock();
                }
                finally {
                    if (lockFile.isInvalid()) {
                        lockFiles.remove(lockFile.getDataFile(), lockFile);
                        lockFile.notifyAll();
                    }
                }
            }
        }
    }

    class LockFile {
        private final File dataFile;
        private final File lockFile;
        private FileLock fileLock;
        private RandomAccessFile raFile;
        private int refCount;
        private Thread owner;
        private final Map<Thread, AtomicInteger> clients = new HashMap<Thread, AtomicInteger>();

        public LockFile(File dataFile) {
            this.dataFile = dataFile;
            this.lockFile = dataFile.isDirectory() ? new File(dataFile, ".aetherlock") : new File(String.valueOf(dataFile.getPath()) + ".aetherlock");
        }

        public File getDataFile() {
            return this.dataFile;
        }

        public boolean lock(boolean write) throws IOException {
            if (this.isInvalid()) {
                throw new IllegalStateException("lock for " + this.dataFile + " has been invalidated");
            }
            if (this.isClosed()) {
                this.open(write);
                return true;
            }
            if (this.isReentrant(write)) {
                this.incRefCount();
                return true;
            }
            if (this.isAlreadyHoldByCurrentThread()) {
                throw new IllegalStateException("Cannot acquire " + (write ? "write" : "read") + " lock on " + this.dataFile + " for thread " + Thread.currentThread() + " which already holds incompatible lock");
            }
            return false;
        }

        public void unlock() throws IOException {
            if (this.decRefCount() <= 0) {
                this.close();
            }
        }

        FileLock getFileLock() {
            return this.fileLock;
        }

        public boolean isInvalid() {
            return this.refCount < 0;
        }

        public boolean isShared() {
            if (this.fileLock == null) {
                throw new IllegalStateException("lock not acquired");
            }
            return this.fileLock.isShared();
        }

        private boolean isClosed() {
            return this.fileLock == null;
        }

        private boolean isReentrant(boolean write) {
            if (this.isShared()) {
                return !write;
            }
            return Thread.currentThread() == this.owner;
        }

        private boolean isAlreadyHoldByCurrentThread() {
            return this.clients.get(Thread.currentThread()) != null;
        }

        /*
         * Unable to fully structure code
         */
        private void open(boolean write) throws IOException {
            block12: {
                this.refCount = 1;
                this.owner = write != false ? Thread.currentThread() : null;
                this.clients.put(Thread.currentThread(), new AtomicInteger(1));
                raf = null;
                lock = null;
                interrupted = false;
                while (true) lbl-1000:
                // 3 sources

                {
                    raf = DefaultFileManager.access$0(DefaultFileManager.this, this.lockFile, "rw");
                    try {
                        lock = raf.getChannel().lock(0L, 1L, write == false);
                        if (lock == null) {
                            throw new FileLockInterruptionException();
                        }
                        break block12;
                    }
                    catch (FileLockInterruptionException v0) {
                        interrupted |= Thread.interrupted();
                        DefaultFileManager.access$3(DefaultFileManager.this, raf);
                    }
                    catch (IOException e) {
                        DefaultFileManager.access$3(DefaultFileManager.this, raf);
                        if (this.isPseudoDeadlock(e)) {
                            DefaultFileManager.access$1(DefaultFileManager.this).debug("OS detected pseudo deadlock for " + this.lockFile + ", retrying locking");
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException v1) {
                                interrupted = true;
                            }
                            continue;
                        }
                        this.delete();
                        throw e;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            this.raFile = raf;
            this.fileLock = lock;
        }

        private boolean isPseudoDeadlock(IOException e) {
            String msg = e.getMessage();
            return msg != null && msg.toLowerCase(Locale.ENGLISH).contains("deadlock");
        }

        private void close() throws IOException {
            block11: {
                this.refCount = -1;
                if (this.fileLock != null) {
                    try {
                        try {
                            if (this.fileLock.isValid()) {
                                this.fileLock.release();
                            }
                        }
                        catch (IOException e) {
                            DefaultFileManager.this.logger.warn("Failed to release lock on " + this.lockFile + ": " + e);
                            this.fileLock = null;
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        this.fileLock = null;
                        throw throwable;
                    }
                    this.fileLock = null;
                }
            }
            if (this.raFile != null) {
                try {
                    this.raFile.close();
                }
                finally {
                    this.raFile = null;
                    this.delete();
                }
            }
        }

        private void delete() {
            if (this.lockFile != null && !this.lockFile.delete() && this.lockFile.exists()) {
                this.lockFile.deleteOnExit();
            }
        }

        private int incRefCount() {
            AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
            if (clientRefCount == null) {
                this.clients.put(Thread.currentThread(), new AtomicInteger(1));
            } else {
                clientRefCount.incrementAndGet();
            }
            return ++this.refCount;
        }

        private int decRefCount() {
            AtomicInteger clientRefCount = this.clients.get(Thread.currentThread());
            if (clientRefCount != null && clientRefCount.decrementAndGet() <= 0) {
                this.clients.remove(Thread.currentThread());
            }
            return --this.refCount;
        }

        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

