/*
 * Decompiled with CFR 0.152.
 */
package io.takari.aether.localrepo;

import io.takari.aether.localrepo.TrackingFileManager;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.SessionData;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.UpdateCheck;
import org.eclipse.aether.impl.UpdateCheckManager;
import org.eclipse.aether.impl.UpdatePolicyAnalyzer;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ResolutionErrorPolicy;
import org.eclipse.aether.resolution.ResolutionErrorPolicyRequest;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="takari")
@Singleton
public class TakariUpdateCheckManager
implements UpdateCheckManager {
    private Logger logger = LoggerFactory.getLogger(TakariUpdateCheckManager.class);
    private static final String ERROR_FLAG = "maven.retryOnDownloadError";
    @Inject
    private UpdatePolicyAnalyzer updatePolicyAnalyzer;
    private static final String UPDATED_KEY_SUFFIX = ".lastUpdated";
    private static final String ERROR_KEY_SUFFIX = ".error";
    private static final String NOT_FOUND = "";
    private static final String SESSION_CHECKS = "updateCheckManager.checks";
    private final boolean allowImmediateRetryOfDownloadFailures = System.getProperty("maven.retryOnDownloadError") != null ? Boolean.getBoolean("maven.retryOnDownloadError") : false;

    public UpdateCheckManager setUpdatePolicyAnalyzer(UpdatePolicyAnalyzer updatePolicyAnalyzer) {
        this.updatePolicyAnalyzer = updatePolicyAnalyzer;
        return this;
    }

    public void checkArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", locally installed artifact up-to-date.");
            }
            check.setRequired(false);
            return;
        }
        Artifact artifact = (Artifact)check.getItem();
        RemoteRepository repository = check.getRepository();
        File artifactFile = check.getFile();
        if (artifactFile == null) {
            throw new IllegalArgumentException(String.format("The artifact '%s' has no file attached", artifact));
        }
        boolean fileExists = check.isFileValid() && artifactFile.exists();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, artifactFile, repository);
        String dataKey = this.getDataKey(artifact, artifactFile, repository);
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? artifactFile.lastModified() : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, artifact, artifactFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isAlreadyUpdated(session.getData(), updateKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", already updated during this session.");
            }
            check.setRequired(false);
            if (error != null) {
                check.setException((RepositoryException)this.newException(error, artifact, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", locally cached artifact up-to-date.");
            }
            check.setRequired(false);
        } else {
            int errorPolicy = TakariUpdateCheckManager.getPolicy(session, artifact, repository);
            if (error == null || error.length() <= 0) {
                if ((errorPolicy & 1) != 0) {
                    check.setRequired(false);
                    check.setException((RepositoryException)this.newException(error, artifact, repository));
                } else {
                    check.setRequired(true);
                }
            } else if ((errorPolicy & 2) != 0) {
                check.setRequired(false);
                check.setException((RepositoryException)this.newException(error, artifact, repository));
            } else {
                check.setRequired(true);
            }
        }
    }

    private ArtifactTransferException newException(String error, Artifact artifact, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new ArtifactNotFoundException(artifact, repository, "Failure to find " + artifact + " in " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced");
        }
        return new ArtifactTransferException(artifact, repository, "Failure to transfer " + artifact + " from " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error);
    }

    public void checkMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        long lastUpdated;
        if (check.getLocalLastUpdated() != 0L && !this.isUpdatedRequired(session, check.getLocalLastUpdated(), check.getPolicy())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", locally installed metadata up-to-date.");
            }
            check.setRequired(false);
            return;
        }
        Metadata metadata = (Metadata)check.getItem();
        RemoteRepository repository = check.getRepository();
        File metadataFile = check.getFile();
        if (metadataFile == null) {
            throw new IllegalArgumentException(String.format("The metadata '%s' has no file attached", metadata));
        }
        boolean fileExists = check.isFileValid() && metadataFile.exists();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        Properties props = this.read(touchFile);
        String updateKey = this.getUpdateKey(session, metadataFile, repository);
        String dataKey = this.getDataKey(metadata, metadataFile, check.getAuthoritativeRepository());
        String error = this.getError(props, dataKey);
        if (error == null) {
            lastUpdated = fileExists ? this.getLastUpdated(props, dataKey) : 0L;
        } else if (error.length() <= 0) {
            lastUpdated = this.getLastUpdated(props, dataKey);
        } else {
            String transferKey = this.getTransferKey(session, metadata, metadataFile, repository);
            lastUpdated = this.getLastUpdated(props, transferKey);
        }
        if (lastUpdated == 0L) {
            check.setRequired(true);
        } else if (this.isAlreadyUpdated(session.getData(), updateKey)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", already updated during this session.");
            }
            check.setRequired(false);
            if (error != null) {
                check.setException((RepositoryException)this.newException(error, metadata, repository));
            }
        } else if (this.isUpdatedRequired(session, lastUpdated, check.getPolicy())) {
            check.setRequired(true);
        } else if (fileExists) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Skipped remote request for " + check.getItem() + ", locally cached metadata up-to-date.");
            }
            check.setRequired(false);
        } else {
            int errorPolicy = TakariUpdateCheckManager.getPolicy(session, metadata, repository);
            if (error == null || error.length() <= 0) {
                if ((errorPolicy & 1) != 0) {
                    check.setRequired(false);
                    check.setException((RepositoryException)this.newException(error, metadata, repository));
                } else {
                    check.setRequired(true);
                }
            } else if ((errorPolicy & 2) != 0) {
                check.setRequired(false);
                check.setException((RepositoryException)this.newException(error, metadata, repository));
            } else {
                check.setRequired(true);
            }
        }
    }

    private MetadataTransferException newException(String error, Metadata metadata, RemoteRepository repository) {
        if (error == null || error.length() <= 0) {
            return new MetadataNotFoundException(metadata, repository, "Failure to find " + metadata + " in " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced");
        }
        return new MetadataTransferException(metadata, repository, "Failure to transfer " + metadata + " from " + repository.getUrl() + " was cached in the local repository, " + "resolution will not be reattempted until the update interval of " + repository.getId() + " has elapsed or updates are forced. Original error: " + error);
    }

    private long getLastUpdated(Properties props, String key) {
        String value = props.getProperty(String.valueOf(key) + UPDATED_KEY_SUFFIX, NOT_FOUND);
        try {
            return value.length() > 0 ? Long.parseLong(value) : 1L;
        }
        catch (NumberFormatException e) {
            this.logger.debug("Cannot parse lastUpdated date: '" + value + "'. Ignoring.", (Throwable)e);
            return 1L;
        }
    }

    private String getError(Properties props, String key) {
        return props.getProperty(String.valueOf(key) + ERROR_KEY_SUFFIX);
    }

    private File getTouchFile(Artifact artifact, File artifactFile) {
        return new File(String.valueOf(artifactFile.getPath()) + UPDATED_KEY_SUFFIX);
    }

    private File getTouchFile(Metadata metadata, File metadataFile) {
        return new File(metadataFile.getParent(), "resolver-status.properties");
    }

    private String getDataKey(Artifact artifact, File artifactFile, RemoteRepository repository) {
        Set<String> mirroredUrls = Collections.emptySet();
        if (repository.isRepositoryManager()) {
            mirroredUrls = new TreeSet<String>();
            for (RemoteRepository mirroredRepository : repository.getMirroredRepositories()) {
                mirroredUrls.add(this.normalizeRepoUrl(mirroredRepository.getUrl()));
            }
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        for (String mirroredUrl : mirroredUrls) {
            buffer.append('+').append(mirroredUrl);
        }
        return buffer.toString();
    }

    private String getTransferKey(RepositorySystemSession session, Artifact artifact, File artifactFile, RemoteRepository repository) {
        return this.getRepoKey(session, repository);
    }

    private String getDataKey(Metadata metadata, File metadataFile, RemoteRepository repository) {
        return metadataFile.getName();
    }

    private String getTransferKey(RepositorySystemSession session, Metadata metadata, File metadataFile, RemoteRepository repository) {
        return String.valueOf(metadataFile.getName()) + '/' + this.getRepoKey(session, repository);
    }

    private String getRepoKey(RepositorySystemSession session, RemoteRepository repository) {
        StringBuilder buffer = new StringBuilder(128);
        Proxy proxy = repository.getProxy();
        if (proxy != null) {
            buffer.append(AuthenticationDigest.forProxy((RepositorySystemSession)session, (RemoteRepository)repository)).append('@');
            buffer.append(proxy.getHost()).append(':').append(proxy.getPort()).append('>');
        }
        buffer.append(AuthenticationDigest.forRepository((RepositorySystemSession)session, (RemoteRepository)repository)).append('@');
        buffer.append(repository.getContentType()).append('-');
        buffer.append(repository.getId()).append('-');
        buffer.append(this.normalizeRepoUrl(repository.getUrl()));
        return buffer.toString();
    }

    private String normalizeRepoUrl(String url) {
        String result = url;
        if (url != null && url.length() > 0 && !url.endsWith("/")) {
            result = String.valueOf(url) + '/';
        }
        return result;
    }

    private String getUpdateKey(RepositorySystemSession session, File file, RemoteRepository repository) {
        return String.valueOf(file.getAbsolutePath()) + '|' + this.getRepoKey(session, repository);
    }

    private boolean isAlreadyUpdated(SessionData data, Object updateKey) {
        Object checkedFiles = data.get((Object)SESSION_CHECKS);
        if (!(checkedFiles instanceof Map)) {
            return false;
        }
        return ((Map)checkedFiles).containsKey(updateKey);
    }

    private void setUpdated(SessionData data, Object updateKey) {
        Object checkedFiles = data.get((Object)SESSION_CHECKS);
        while (!(checkedFiles instanceof Map)) {
            Object old = checkedFiles;
            if (data.set((Object)SESSION_CHECKS, old, checkedFiles = new ConcurrentHashMap(256))) break;
            checkedFiles = data.get((Object)SESSION_CHECKS);
        }
        ((Map)checkedFiles).put(updateKey, Boolean.TRUE);
    }

    private boolean isUpdatedRequired(RepositorySystemSession session, long lastModified, String policy) {
        return this.updatePolicyAnalyzer.isUpdatedRequired(session, lastModified, policy);
    }

    private Properties read(File touchFile) {
        Properties props = new TrackingFileManager().read(touchFile);
        return props != null ? props : new Properties();
    }

    public void touchArtifact(RepositorySystemSession session, UpdateCheck<Artifact, ArtifactTransferException> check) {
        Artifact artifact = (Artifact)check.getItem();
        File artifactFile = check.getFile();
        File touchFile = this.getTouchFile(artifact, artifactFile);
        String updateKey = this.getUpdateKey(session, artifactFile, check.getRepository());
        String dataKey = this.getDataKey(artifact, artifactFile, check.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session, artifact, artifactFile, check.getRepository());
        this.setUpdated(session.getData(), updateKey);
        Properties props = this.write(touchFile, dataKey, transferKey, (Exception)check.getException());
        if (artifactFile.exists() && !this.hasErrors(props)) {
            touchFile.delete();
        }
    }

    private boolean hasErrors(Properties props) {
        for (Object key : props.keySet()) {
            if (!key.toString().endsWith(ERROR_KEY_SUFFIX)) continue;
            return true;
        }
        return false;
    }

    public void touchMetadata(RepositorySystemSession session, UpdateCheck<Metadata, MetadataTransferException> check) {
        Metadata metadata = (Metadata)check.getItem();
        File metadataFile = check.getFile();
        File touchFile = this.getTouchFile(metadata, metadataFile);
        String updateKey = this.getUpdateKey(session, metadataFile, check.getRepository());
        String dataKey = this.getDataKey(metadata, metadataFile, check.getAuthoritativeRepository());
        String transferKey = this.getTransferKey(session, metadata, metadataFile, check.getRepository());
        this.setUpdated(session.getData(), updateKey);
        this.write(touchFile, dataKey, transferKey, (Exception)check.getException());
    }

    private Properties write(File touchFile, String dataKey, String transferKey, Exception error) {
        HashMap<String, String> updates = new HashMap<String, String>();
        String timestamp = Long.toString(System.currentTimeMillis());
        if (error == null) {
            updates.put(String.valueOf(dataKey) + ERROR_KEY_SUFFIX, null);
            updates.put(String.valueOf(dataKey) + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(String.valueOf(transferKey) + UPDATED_KEY_SUFFIX, null);
        } else if (error instanceof ArtifactNotFoundException || error instanceof MetadataNotFoundException) {
            updates.put(String.valueOf(dataKey) + ERROR_KEY_SUFFIX, NOT_FOUND);
            updates.put(String.valueOf(dataKey) + UPDATED_KEY_SUFFIX, timestamp);
            updates.put(String.valueOf(transferKey) + UPDATED_KEY_SUFFIX, null);
        } else {
            String msg = error.getMessage();
            if (msg == null || msg.length() <= 0) {
                msg = error.getClass().getSimpleName();
            }
            updates.put(String.valueOf(dataKey) + ERROR_KEY_SUFFIX, msg);
            updates.put(String.valueOf(dataKey) + UPDATED_KEY_SUFFIX, null);
            updates.put(String.valueOf(transferKey) + UPDATED_KEY_SUFFIX, timestamp);
        }
        if (this.allowImmediateRetryOfDownloadFailures) {
            return new Properties();
        }
        return new TrackingFileManager().update(touchFile, updates);
    }

    private static int getPolicy(RepositorySystemSession session, Artifact artifact, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getArtifactPolicy(session, new ResolutionErrorPolicyRequest((Object)artifact, repository));
    }

    private static int getPolicy(RepositorySystemSession session, Metadata metadata, RemoteRepository repository) {
        ResolutionErrorPolicy rep = session.getResolutionErrorPolicy();
        if (rep == null) {
            return 0;
        }
        return rep.getMetadataPolicy(session, new ResolutionErrorPolicyRequest((Object)metadata, repository));
    }
}

